if exist('REVS','var') && (REVS.verbose > 0)  disp(['Loading ' mfilename]); end

electric.battery = class_REVS_battery;

electric.battery.cell.chemistry = enum_battery_type.lead_acid;
electric.battery.cell.capacity_nominal_Ah = 41;
electric.battery.cell.powerlimit_map_index_soc_norm = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
electric.battery.cell.powerlimit_map_index_temp_degC = [0 100];
electric.battery.cell.powerlimit_discharge_map_W = [2310 2322 2349 2373 2409 2436 2460 2496 2508 2505;2310 2322 2349 2373 2409 2436 2460 2496 2508 2505];
electric.battery.cell.powerlimit_charge_map_W = [3153 3132 3027 2925 2883 2838 2676 2514 2235 2094;3153 3132 3027 2925 2883 2838 2676 2514 2235 2094];
electric.battery.cell.open_circuit_voltage_map_index_temp_degC = [0 100];
electric.battery.cell.open_circuit_voltage_map_index_soc_norm = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768 0.867 1];
electric.battery.cell.open_circuit_voltage_map_discharge_V = [1.975 1.98833333333333 2.01166666666667 2.03333333333333 2.05666666666667 2.07666666666667 2.09666666666667 2.10833333333333 2.12166666666667 2.14666666666667 2.205;1.975 1.98833333333333 2.01166666666667 2.03333333333333 2.05666666666667 2.07666666666667 2.09666666666667 2.10833333333333 2.12166666666667 2.14666666666667 2.205];
electric.battery.cell.open_circuit_voltage_map_charge_V = [1.975 1.98833333333333 2.01166666666667 2.03333333333333 2.05666666666667 2.07666666666667 2.09666666666667 2.10833333333333 2.12166666666667 2.14666666666667 2.205;1.975 1.98833333333333 2.01166666666667 2.03333333333333 2.05666666666667 2.07666666666667 2.09666666666667 2.10833333333333 2.12166666666667 2.14666666666667 2.205];
electric.battery.cell.use_average_open_circuit_Volts = true;
electric.battery.cell.transient_RC_index_soc_norm = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
electric.battery.cell.transient_RC_index_temp_degC = [0 100];
electric.battery.cell.transient_R_discharge_short_term_Ohms = [0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667;0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667];
electric.battery.cell.transient_R_charge_short_term_Ohms = [0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667;0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667];
electric.battery.cell.transient_R_discharge_long_term_Ohms = [0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667;0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667];
electric.battery.cell.transient_R_charge_long_term_Ohms = [0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667;0.00788333333333333 0.00543333333333333 0.0044 0.00413333333333333 0.00398333333333333 0.00426666666666667 0.00493333333333333 0.00533333333333333 0.00541666666666667];
electric.battery.cell.transient_C_discharge_short_term_Farads = [1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2;1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2];
electric.battery.cell.transient_C_charge_short_term_Farads = [1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2;1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2];
electric.battery.cell.transient_C_discharge_long_term_Farads = [1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2;1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2];
electric.battery.cell.transient_C_charge_long_term_Farads = [1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2;1306.8 1848.6 2219.4 2521.8 2880.6 3033 2971.8 3028.8 3229.2];
electric.battery.cell.resistance_map_index_temp_degC = [0 100];
electric.battery.cell.resistance_map_index_soc_norm = [0.1884 0.2411 0.333 0.419 0.511 0.59 0.669 0.715 0.768];
electric.battery.cell.resistance_map_discharge_Ohms = [0.00521666666666667 0.00348333333333333 0.00245 0.0021 0.00175 0.00171666666666667 0.00165 0.0017 0.00158333333333333;0.00521666666666667 0.00348333333333333 0.00245 0.0021 0.00175 0.00171666666666667 0.00165 0.0017 0.00158333333333333];
electric.battery.cell.resistance_map_charge_Ohms = [0.00521666666666667 0.00348333333333333 0.00245 0.0021 0.00175 0.00171666666666667 0.00165 0.0017 0.00158333333333333;0.00521666666666667 0.00348333333333333 0.00245 0.0021 0.00175 0.00171666666666667 0.00165 0.0017 0.00158333333333333];
electric.battery.cell.charge_efficiency_index_temp_degC = [-30 0 20 40];
electric.battery.cell.charge_efficiency_index_soc_norm = [0 0.8 0.85 0.9 1];
electric.battery.cell.charge_efficiency_map_norm = [0.99 0.99 0.99 0.98 0.97;0.99 0.99 0.99 0.98 0.97;0.99 0.99 0.99 0.98 0.97;0.99 0.99 0.99 0.98 0.97];

electric.battery.cell.temperature_power_derate_index_temp_degC = [-30 -20 -10 0 10 20 30 40 50 55];
electric.battery.cell.temperature_power_discharge_derate_norm = [0.1139 0.3454 0.5528 0.7314 0.8763 0.9828 1.046 1.0611 1.0233 0.1139];
electric.battery.cell.temperature_power_charge_derate_norm = [0.027 0.09675 0.1665 0.4031 0.6776 0.9351 1.1206 1.179 1.0554 0.027];
electric.battery.use_second_order_model = false;
electric.battery.initial_soc_norm = 0.768;
electric.battery.num_parallel_cells = 1;
electric.battery.num_series_cells = 6;
electric.battery.use_average_open_circuit_Volts = true;

electric.battery.discharge_derate_soc_norm = [0.25 0.28];
electric.battery.charge_derate_soc_norm = [0.92 0.95];

electric.battery.thermal.initial_temp_degC = 20;
electric.battery.thermal.pack_mass_kg = 3.9 * electric.battery.num_cells;
electric.battery.thermal.specific_heat_capacity_JpkgK = 3960;

electric.battery.thermal.heat_transfer_coefficient_Wpm2K = 10.5 * 0.3; % Base * hrate_cal
electric.battery.thermal.pack_heat_transfer_area_m2 = 0.3078 * electric.battery.num_cells;
